<?php

// Add this to your helpers.php file or create a new NavigationHelper class

if (!function_exists('get_navigation_links')) {
    /**
     * Get the navigation links from configuration
     *
     * @return array
     */
    function get_navigation_links()
    {
        $links = config_value('navigation_links', '[]');
        if (is_string($links)) {
            $links = json_decode($links, true) ?: [];
        }
        
        // Filter active links and sort by order
        $activeLinks = array_filter($links, function($link) {
            return ($link['active'] ?? true) && evaluate_nav_condition($link);
        });
        
        usort($activeLinks, function($a, $b) {
            return ($a['order'] ?? 0) <=> ($b['order'] ?? 0);
        });
        
        return $activeLinks;
    }
}

if (!function_exists('evaluate_nav_condition')) {
    /**
     * Evaluate navigation link condition
     *
     * @param array $link
     * @return bool
     */
    function evaluate_nav_condition($link)
    {
        if (!isset($link['condition']) || empty($link['condition'])) {
            return true;
        }
        
        $condition = $link['condition'];
        
        // Handle common conditions
        if (strpos($condition, 'config_value') !== false) {
            // Replace config_value calls with actual values
            $condition = preg_replace_callback(
                '/config_value\(["\']([^"\']+)["\']\)/',
                function($matches) {
                    return var_export(config_value($matches[1]), true);
                },
                $condition
            );
            
            // Remove !! operator and evaluate
            $condition = str_replace('!!', '', $condition);
            
            try {
                return (bool) eval("return $condition;");
            } catch (Exception $e) {
                return false;
            }
        }
        
        return true;
    }
}

if (!function_exists('render_nav_url')) {
    /**
     * Render navigation URL, handling Laravel route syntax
     *
     * @param string $url
     * @return string
     */
    function render_nav_url($url)
    {
        // Handle Laravel route syntax {{ route('route.name') }}
        if (preg_match('/\{\{\s*route\(["\']([^"\']+)["\']\)\s*\}\}/', $url, $matches)) {
            try {
                return route($matches[1]);
            } catch (Exception $e) {
                return '#';
            }
        }
        
        // Handle other Laravel syntax like {{ url('/path') }}
        if (preg_match('/\{\{\s*url\(["\']([^"\']+)["\']\)\s*\}\}/', $url, $matches)) {
            return url($matches[1]);
        }
        
        return $url;
    }
}

if (!function_exists('is_nav_link_active')) {
    /**
     * Check if navigation link is active based on current route
     *
     * @param array $link
     * @return bool
     */
    function is_nav_link_active($link)
    {
        if (!isset($link['route']) || empty($link['route'])) {
            return false;
        }
        
        $route = $link['route'];
        
        // Handle wildcard routes like 'forum.*'
        if (str_ends_with($route, '.*')) {
            $routePrefix = str_replace('.*', '', $route);
            return request()->routeIs($routePrefix . '*');
        }
        
        return request()->routeIs($route);
    }
}